# -*- coding: utf-8 -*-
"""r12.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1nNWszDmS4IUQASPJEXiVq8NJYhlJF5Mg
"""



import numpy as np
import matplotlib.pyplot as plt

import pandas as pd

# UWAGA: poniżej zdefiniowano globalne ustawienia związane z wyglądem rysunków,
# które wykorzystano do wygenerowania rysunków pokazanych w książce

from IPython import display
display.set_matplotlib_formats('svg') # Rysunki w formacie wektorowym
plt.rcParams.update({'font.size':14}) # Rozmiar czcionki

"""# Dane dotyczące liczby wypożyczonych rowerów"""

# Źródło danych
# V E Sathishkumar, Jangwoo Park i Yongyun Cho, Using Data Mining Techniques for Bike Sharing Demand Prediction in Metropolitan City,
# Computer Communications, 153, str 353–366, marzec 2020.
# Dane pobrane z https://archive.ics.uci.edu/ml/datasets/Seoul+Bike+Sharing+Demand.

# import danych
url = "https://archive.ics.uci.edu/ml/machine-learning-databases/00560/SeoulBikeData.csv"
data = pd.read_csv(url,sep=',',encoding='unicode_escape')

data

data.plot(x='Date',y='Rented Bike Count',color='k',marker='.',linestyle='none',
          figsize=(12,6),xlabel='Data', ylabel='Liczba wypożyczonych rowerów')
plt.legend(['Liczba wypożyczonych rowerów'])
plt.savefig('rys12.1a.png',dpi=300, bbox_inches='tight')
plt.show()

data.plot(x='Date',y='Rainfall(mm)',color='k',marker='.',linestyle='none',
          figsize=(12,6),ylabel='Opad (mm)', xlabel='Data');
plt.legend(['Opad (mm)'])

plt.savefig('rys12.1b.png',dpi=300)
plt.show()

data.corr()

columns2use = ['Rented Bike Count','Hour','Temperature(°C)','Rainfall(mm)']
colsshort = ['Liczba\nrowerów','Godzina','Temp.','Opad']


R = data[columns2use].corr()

plt.figure(figsize=(6,6))
plt.imshow(R.values,cmap='gray')
plt.xticks(range(4),labels=colsshort)
plt.yticks(range(4),labels=colsshort)

for (j,i),num in np.ndenumerate(R.values):
  plt.text(i,j,f'{num:.2f}',color=[.8,.8,.8],ha='center',va='center',fontweight='bold',fontsize=15)

plt.savefig('rys12.2.png',dpi=300, bbox_inches='tight')
plt.show()

data.replace(['Spring','Summer', 'Autumn','Winter'],[1,1,0,0], inplace=True)
data

# tworzę macierz zależności i dodaję do niej punkt przecięcia
desmat = data[['Rainfall(mm)','Seasons']].to_numpy()
desmat = np.append(desmat,np.ones((desmat.shape[0],1)),axis=1)

# pobieram dane z ramki danych
y = data[['Rented Bike Count']].to_numpy()


plt.figure(figsize=(5,8))
plt.imshow(desmat,aspect='auto',vmin=0,vmax=1,origin='lower',interpolation='nearest',cmap='gray')
plt.ylabel('Obserwacje')
plt.xlabel('Regresor')
plt.title('Macierz zależności')
plt.xticks(range(3),labels=['Opad','Pora roku','Współczynnik\nprzecięcia'])
plt.savefig('rys12.3a.png',dpi=300,bbox_inches='tight')
plt.show()

plt.figure(figsize=(5,8))

plt.plot(desmat[desmat[:,1]==0,0],y[desmat[:,1]==0],'o',markerfacecolor=(0,0,0,.1),markeredgecolor=(0,0,0,.9),label='Winter')
plt.plot(desmat[desmat[:,1]==1,0],y[desmat[:,1]==1],'s',markerfacecolor=(1,0,0,.1),markeredgecolor=(1,0,0,.6),label='Summer')

plt.xlabel('Opad')
plt.ylabel('Liczba wypożyczonych rowerów')
plt.legend(['Zima', 'Lato'])
plt.savefig('rys12.3b.png',dpi=300,bbox_inches='tight')
plt.show()

# dopasowuję model za pomocą metody najmniejszych kwadratów
beta = np.linalg.lstsq(desmat,y,rcond=None)
beta[0]

yHat = desmat@beta[0]

modelfit = np.corrcoef(y.T,yHat.T)[0,1]**2


plt.figure(figsize=(10,6))
plt.plot(y[desmat[:,1]==0],yHat[desmat[:,1]==0],'o',markerfacecolor=(0,0,0,.1),markeredgecolor=(0,0,0,.9),label='Zima')
plt.plot(y[desmat[:,1]==1],yHat[desmat[:,1]==1],'s',markerfacecolor=(1,0,0,.1),markeredgecolor=(1,0,0,.6),label='Lato')
plt.legend()
plt.xlabel('Rzeczywista liczba rowerów')
plt.ylabel('Przewidywana liczba rowerów')
plt.title(f'Dopasowanie modelu ($R^2$): {modelfit:.3f}')
plt.savefig('rys12.4.png',dpi=300)
plt.show()

"""# Statsmodels"""

import statsmodels.api as sm

# przygotowanie danych (dane pozostają w ramce danych Pandas)
desmat_df  = data[['Rainfall(mm)','Seasons']]
obsdata_df = data['Rented Bike Count']

# tworzę i dopasowuję model (muszę jawnie dodać do modelu punkt przecięcia)
desmat_df = sm.add_constant(desmat_df)
model = sm.OLS(obsdata_df,desmat_df).fit()
print( model.summary() )



"""# Regresja wielomianowa"""

x = np.linspace(-2,2,40)
maxorder = 3
desmat = np.zeros((len(x),maxorder+1))
xlab = []


_,axs = plt.subplots(1,2,gridspec_kw={'width_ratios':[2,1]}, figsize=(10,6))

for i in range(maxorder+1):
  axs[0].plot(x,x**i,linewidth=3,label='$y=x^%g$'%i)
  desmat[:,i] = x**i
  xlab.append( '$x^%g$'%i )

axs[0].set(xlim=[-2,2],xlabel='x')
axs[0].set(ylim=[-6,6],ylabel='y = f(x)')
axs[0].grid()
axs[0].legend()
axs[0].set_title('Regresory')

axs[1].imshow(desmat,cmap='gray',aspect='auto',vmin=-2,vmax=2,extent=[-.5,maxorder+.5,x[-1],x[0]])
axs[1].set(xticks=range(maxorder+1),xticklabels=xlab)
axs[1].set_title('Macierz zależności')

plt.savefig('rys12.5.png',dpi=300)
plt.show()



year       = [1534, 1737, 1803, 1928, 1960, 1975, 1987, 2023, 2057, 2100 ]
doubleTime = [ 697,  594,  260,  125,   76,   47,   37,   48,   70,  109 ]

N = len(year)


plt.figure(figsize=(8,6))
plt.plot(year,doubleTime,'ks-',markersize=10)

plt.xlabel('Rok')
plt.ylabel('Liczba lat potrzebnych do dwukrotnego\nzwiększenia się populacji')
plt.savefig('rys12.6.png',dpi=300)
plt.show()

## Źródło:
# MaxRoser, HannahRitchie i EstebanOrtiz-Ospina, World Population Growth, OurWorldInData.org, 2013,
# https://ourworldindata.org/world-population-growth.

# macierz zależności
X = np.zeros((N,4))

for i in range(4):
  X[:,i] = np.array(year)**i


print(X.astype(int))

# dopasowanie modelu i przeprowadzenie prognozy
beta = np.linalg.lstsq(X,doubleTime, rcond=None)
yHat = X@beta[0]


plt.figure(figsize=(8,6))
plt.plot(year,doubleTime,'ks-',markersize=10,label=r'$y$')
plt.plot(year,yHat,'o-',color=[.7,.7,.7],label=r'$\hat{y}$')

plt.legend()
plt.xlabel('Rok')
plt.ylabel('Liczba lat potrzebnych do dwukrotnego\nzwiększenia się populacji')
plt.savefig('rys12.7.png',dpi=300)
plt.show()

beta = np.polyfit(year,doubleTime,3) # wielomian trzeciego stopnia
yHat = np.polyval(beta,year)


plt.figure(figsize=(8,6))
plt.plot(year,doubleTime,'ks-',markersize=10,label=r'$y$')
plt.plot(year,yHat,'o-',color=[.7,.7,.7],label=r'$\hat{y}$')

plt.legend()
plt.xlabel('Rok')
plt.ylabel('Liczba lat potrzebnych do dwukrotnego\nzwiększenia się populacji')
plt.show()





"""# Ćwiczenie 1. (dane na temat rowerów)"""

# odtwarzam macierz zależności i wektor danych
desmat = data[['Rainfall(mm)','Seasons']].to_numpy()
desmat = np.append(desmat,np.ones((desmat.shape[0],1)),axis=1)
y = data[['Rented Bike Count']].to_numpy()

# wybieram dni, w których padało

desmat_norain = desmat[desmat[:,0]>0,:]
y_norain = y[desmat[:,0]>0,:]

# wykreślam dane
plt.figure(figsize=(10,6))

# osobno dla okresu jesień-zima i wiosna-lato
plt.plot(desmat_norain[desmat_norain[:,1]==0,0],y_norain[desmat_norain[:,1]==0],'o',
         markerfacecolor=(0,0,0,.1),markeredgecolor=(0,0,0,.9),label='Winter')
plt.plot(desmat_norain[desmat_norain[:,1]==1,0],y_norain[desmat_norain[:,1]==1],'s',
         markerfacecolor=(1,0,0,.1),markeredgecolor=(1,0,0,.6),label='Summer')

plt.xlabel('Opad')
plt.ylabel('Liczba wypożyczonych rowerów')
plt.title('Dane dotyczące jedynie dni, w których padało')
plt.legend(['Zima', 'Lato'])
plt.show()



# przeprowadzam regresję
beta_norain = np.linalg.lstsq(desmat_norain,y_norain,rcond=None)


# obliczam przewidywania
yHat_norain = desmat_norain @ beta_norain[0]

# sprawdzam dopasowanie modelu (R^2)
modelfit = np.corrcoef(y_norain.T,yHat_norain.T)[0,1]**2



## wykreślam wyniki
plt.figure(figsize=(10,6))
plt.plot(y_norain[desmat_norain[:,1]==0],yHat_norain[desmat_norain[:,1]==0],'o',
         markerfacecolor=(0,0,0,.1),markeredgecolor=(0,0,0,.9),label='Zima')
plt.plot(y_norain[desmat_norain[:,1]==1],yHat_norain[desmat_norain[:,1]==1],'s',
         markerfacecolor=(1,0,0,.1),markeredgecolor=(1,0,0,.6),label='Lato')

plt.legend()
plt.xlabel('Rzeczywista liczba rowerów')
plt.ylabel('Przewidywana liczba rowerów')
plt.title(f'Dopasowanie modelu ($R^2$): {modelfit:.3f}')
plt.show()

"""# Ćwiczenie 2. (dane na temat rowerów)"""

# tworzę macierz zależności
desmat = data[['Rainfall(mm)','Temperature(°C)']].to_numpy()
desmat = np.append(desmat,np.ones((desmat.shape[0],1)),axis=1)


beta = np.linalg.lstsq(desmat,y,rcond=None)
yHat = desmat@beta[0]

# sprawdzam dopasowanie modelu (R^2)
modelfit = np.corrcoef(y.T,yHat.T)[0,1]**2

# tworzę wykres
plt.figure(figsize=(10,6))
plt.plot(y,yHat,'o',markerfacecolor=(0,0,0,.1),markeredgecolor=(0,0,0,.9))
plt.xlabel('Rzeczywista liczba rowerów')
plt.ylabel('Przewidywana liczba rowerów')
plt.title(f'Dopasowanie modelu ($R^2$): {modelfit:.3f}')
plt.savefig('rys12.9.png',dpi=300)
plt.show()



"""# Ćwiczenie 3. (współliniowość)"""

# jakaś losowa kombinacja liniowa
lincombo = 4*desmat[:,0] + .4*desmat[:,1]

# tworzę macierz zależności
desmatM = data[['Rainfall(mm)','Temperature(°C)']].to_numpy()
desmatM = np.append(desmatM,np.ones((desmatM.shape[0],1)),axis=1)

# rozszerzam macierz zależności
desmatM = np.append(desmatM,lincombo.reshape(-1,1),axis=1)


print(f'Wymiary macierzy zależności: {desmatM.shape}')
print(f'Rząd macierzy zależności: {np.linalg.matrix_rank(desmatM)}')

# macierz korelacji (uwaga: wartości nan dla b i c wynikają z braku wariancji)
oSettings = np.seterr() # domyślny sposób obsługi błędów
np.seterr(all='ignore') # ignoruję ostrzeżenia na temat korelacji
print(f'\nMacierz korelacji macierzy zależności:')
print(np.round(np.corrcoef(desmatM.T),5))
np.seterr(**oSettings); # przywrócenie domyślnego sposobu obsługi błędów

pd.DataFrame(desmatM,columns=['Rain','Temp','Int','Combo']).corr()

### przy użyciu odwrotności lewostronnej

# dopasowanie modelu
X_leftinv = np.linalg.inv(desmatM.T@desmatM) @ desmatM.T

# wyznaczam współczynniki
beta1 = X_leftinv @ y
yHat  = desmatM@beta1

# ocena dopasowania modelu do danych (R^2)
modelfit1 = np.corrcoef(y.T,yHat.T)[0,1]**2
print(modelfit1)

### za pomocą metody lstsq z NumPy

# dopasowanie modelu
beta2 = np.linalg.lstsq(desmatM,y,rcond=None)
yHat  = desmatM@beta2[0]

# ocena dopasowania modelu do danych (R^2)
modelfit2 = np.corrcoef(y.T,yHat.T)[0,1]**2
print(modelfit2)

### za pomocą statsmodels

# zamieniam macierz zależności w ramkę danych Pandas
desmat_df = pd.DataFrame(desmatM)

# tworzę i dopasowuję model
desmat_df = sm.add_constant(desmat_df)
model = sm.OLS(obsdata_df,desmat_df).fit()


beta3 = model.params.values
modelfit3 = model.rsquared

# wyświetlam wyniki

print('DOPASOWANIE MODELU DO DANYCH:')
print(f'   Odwrotność lewostronna: {modelfit1:.4f}')
print(f'             np.lstsqr   : {modelfit2:.4f}')
print(f'             statsmodels : {modelfit3:.4f}')

print(' ')
print('WSPÓŁCZYNNIKI BETA:')
print(f'   Odwrotność lewostronna: {np.round(beta1.T,3)}')
print(f'             np.lstsqr   : {np.round(beta2[0].T,3)}')
print(f'             statsmodels : {np.round(beta3.T,3)}')



"""# Ćwiczenie 4. (regularyzacja)"""

# współczynnik regularyzacji
gamma = .01

# gamma razy norma
gamnorm = gamma * np.linalg.norm(desmatM,'fro')**2

# odwrotność (X'X+lI)
leftinv = np.linalg.inv(desmatM.T@desmatM + gamnorm*np.eye(desmatM.shape[1]))

print(f"Wymiary inv(X'X + {gamma}*I): {leftinv.shape}")
print(f"   Rząd inv(X'X + {gamma}*I): {np.linalg.matrix_rank(leftinv)}")

# Uwaga: ćwiczenie 7. z rozdziału 13. korzysta z tego kodu. Użyj go jak do niego dojdziesz :)
I_am_reading_chapter_13 = False


# zakres wartości gamma
gs = np.linspace(0,.2,40)

r2s  = np.zeros(gs.shape)
r2sM = np.zeros(gs.shape) # 'M' oznacza współliniowość


# pętla po wartościach gamma
for i in range(len(gs)):

  l = gs[i]*np.linalg.norm(desmat,'fro')**2

  if I_am_reading_chapter_13: # 13.7
    l = gs[i]*np.mean(np.linalg.eig(desmat.T@desmat)[0])

  # obliczam odwrotność lewostronną
  leftinv = np.linalg.inv(desmat.T@desmat + l*np.eye(desmat.shape[1])) @ desmat.T

  # obliczam beta i przewidywania
  b = leftinv @ y
  yHat = desmat@b

  # dopasowanie modelu
  r2s[i] = np.corrcoef(y.T,yHat.T)[0,1]**2


  ### powtarzam dla modelu współliniowego
  l       = gs[i]*np.linalg.norm(desmatM,'fro')**2
  if I_am_reading_chapter_13: # ćwiczenie 13.6
    l     = gs[i]*np.mean(np.linalg.eig(desmatM.T@desmatM)[0])
  leftinv = np.linalg.inv(desmatM.T@desmatM + l*np.eye(desmatM.shape[1])) @ desmatM.T
  b       = leftinv @ y
  yHat    = desmatM@b
  r2sM[i] = np.corrcoef(y.T,yHat.T)[0,1]**2



# wykreślam wyniki
plt.figure(figsize=(8,5))
plt.plot(gs,r2s,'ks-',linewidth=2,label='Orginalne dane')
plt.plot(gs,r2sM,'o-',linewidth=2,label='Współliniowe',color=[.7,.7,.7])
plt.xlabel('Współczynnik $\gamma$')
plt.ylabel('$R^2$')
plt.ylim([.27,.32])
plt.legend()
plt.savefig('rys12.10.png',dpi=300)
plt.show()



"""# Ćwiczenie 5. (regresja wielomianowa)"""

# tworzę wykres
_,axs = plt.subplots(2,5,figsize=(14,5))
axs = axs.flatten()


for oi in range(N):
  beta = np.polyfit(year,doubleTime,oi)
  yHat = np.polyval(beta,year)

  axs[oi].plot(year,doubleTime,'ks-',markersize=10)
  axs[oi].plot(year,yHat,'o--',color=[.7,.7,.7])
  axs[oi].set(xticks=[], yticks=[])
  axs[oi].set_title('Stopień=%g' %oi)

plt.tight_layout()
plt.savefig('rys12.11.png',dpi=300)
plt.show()



"""# Ćwiczenie 6. (przekszukiwanie siatki)"""

# Uwaga: model i dane pochodzą z poprzedniego rozdziału
numcourses = [13,4,12,3,14,13,12,9,11,7,13,11,9,2,5,7,10,0,9,7]
happiness  = [70,25,54,21,80,68,84,62,57,40,60,64,45,38,51,52,58,21,75,70]

# macierz zależności
X = np.hstack((np.ones((20,1)),np.array(numcourses,ndmin=2).T))
beta = np.linalg.lstsq(X,happiness,rcond=None)[0]

# liczba kroków dla każdego parametru (rozdzielczość)
gridResolution = 100


# wyrazy wolne i nachylenia do przetestowania
intercepts = np.linspace(0,80,gridResolution)
slopes = np.linspace(0,6,gridResolution)

# inicjalizacja macierzy
SSEs = np.zeros((len(intercepts),len(slopes)))


# pętla for po parametrach
for inti in range(len(intercepts)):
  for slopei in range(len(slopes)):

    # przewidywania modelu
    yHat = X @ np.array([intercepts[inti],slopes[slopei]]).T

    # suma kwadratów błędów
    SSEs[inti,slopei] = np.sum((yHat-happiness)**2)


# poszukiwanie empirycznego minimum
i,j = np.unravel_index( np.argmin(SSEs),SSEs.shape )
empIntercept,empSlope = intercepts[i], slopes[j]


# wykres
plt.figure(figsize=(6,6))
plt.imshow(SSEs,vmin=2000,vmax=3000,
           extent=[slopes[0],slopes[-1],intercepts[0],intercepts[-1]],
           origin='lower',aspect='auto',cmap='gray')
plt.plot(empSlope,empIntercept,'o',color=[1,.4,.4],markersize=12,label='Minimum z przeszukiwania\nsiatki')
plt.plot(beta[1],beta[0],'x',color=[.4,.7,1],markeredgewidth=4,markersize=10,label='Rozwiązanie\nanalityczne')
plt.colorbar()
plt.xlabel('Współczynnik nachylenia')
plt.ylabel('Punkt przecięcia')
plt.title('SSE (dopasowanie modelu do danych)')
plt.legend()
plt.savefig('rys12.8.png',dpi=300)
plt.show()

print('Rozwiązanie analityczne: ')
print(f'   Punkt przecięcia: {beta[0]:.2f}, Współczynnik nachylenia: {beta[1]:.2f}')
print(' ')
print('Wynik empiryczny: ')
print(f'   Punkt przecięcia: {empIntercept:.2f}, Współczynnik nachylenia: {empSlope:.2f}')



"""# Ćwiczenie 7. (przekszukiwanie siatki)"""

# liczba kroków dla każdego parametru
gridResolution = 20


# wyrazy wolne i nachylenia do przetestowania
intercepts = np.linspace(0,80,gridResolution)
slopes = np.linspace(0,6,gridResolution)

# inicjalizacja macierzy
r2 = np.zeros((len(intercepts),len(slopes)))
allYhat = np.zeros((len(intercepts),len(slopes),len(happiness)))

# pętla for po parametrach
for inti in range(len(intercepts)):
  for slopei in range(len(slopes)):

    # przewidywania modelu
    yHat = X @ np.array([intercepts[inti],slopes[slopei]]).T

    # współczynnik R^2
    r2[inti,slopei] = np.corrcoef(yHat,happiness)[0,1]**2

    # zapisanie wszystkich przewidywań
    allYhat[inti,slopei,:] = yHat


# poszukiwanie empirycznego minimum
i,j = np.unravel_index( np.argmax(r2),r2.shape )
empIntercept,empSlope = intercepts[i], slopes[j]


# wykres
plt.figure(figsize=(6,6))
plt.imshow(r2,vmin=0,vmax=.5,
           extent=[slopes[0],slopes[-1],intercepts[0],intercepts[-1]],
           origin='lower',aspect='auto',cmap='gray')
plt.plot(empSlope,empIntercept,'o',color=[1,.4,.4],markersize=12,label='Minimum z przeszukiwania\nsiatki')
plt.plot(beta[1],beta[0],'x',color=[.4,.7,1],markeredgewidth=4,markersize=10,label='Rozwiązanie\nanalityczne')
plt.colorbar()
plt.xlabel('Współczynnik nachylenia')
plt.ylabel('Punkt przecięcia')
plt.title('R^2 (dopasowanie modelu do danych)')
plt.legend()
plt.show()

print('Rozwiązanie analityczne: ')
print(f'   Punkt przecięcia: {beta[0]:.2f}, Współczynnik nachylenia: {beta[1]:.2f}')
print(' ')
print('Wynik empiryczny: ')
print(f'   Punkt przecięcia: {empIntercept:.2f}, Współczynnik nachylenia: {empSlope:.2f}')

# dlaczego to podejście nie działa?
# zacznę od wykreślenia przewidywań dla poszczególnych parametrów

_,axs = plt.subplots(1,2,figsize=(14,5))

axs[0].plot(allYhat[5,:,:].T,'s-',markersize=3)
axs[0].plot(happiness,'ko-',linewidth=4,label='Obserwacje')
axs[0].set_xlabel('Identyfikator studenta')
axs[0].set_ylabel('Zadowolenie z życia')
axs[0].set_title('Każda prosta ma inne nachylenie')
axs[0].legend()

axs[1].plot(allYhat[:,5,:].T,'s-',markersize=3)
axs[1].plot(happiness,'ko-',linewidth=4,label='Obserwacje')
axs[1].set_xlabel('Identyfikator studenta')
axs[1].set_ylabel('Zadowolenie z życia')
axs[1].set_title('Każda prosta ma inny współczynnik przecięcia')
axs[1].legend()

plt.show()

# Wykresy pokazują, że przewidywane wartości są dość podobne dla różnych par parametrów.
# Przypomnij sobie, że we wzorze na korelację wyśrodkowujemy dane. Możemy spróbować ponownie wykreślić
# dane po wyśrodkowaniu, tj. pokazać jak widzi je korelacja
# Przejdź do następnej komórki...

# Wykresy są analogiczne do powyższych, ale tym razem wyśrodkowałem dane

_,axs = plt.subplots(1,2,figsize=(14,5))

axs[0].plot(allYhat[5,:,:].T - np.mean(allYhat[5,:,:].T,axis=0),'s-',markersize=3)
axs[0].plot(happiness-np.mean(happiness),'ko-',linewidth=4,label='Obserwacje')
axs[0].set_xlabel('Identyfikator studenta')
axs[0].set_ylabel('Zadowolenie z życia')
axs[0].set_title('Każda prosta ma inne nachylenie')
axs[0].legend()

axs[1].plot(allYhat[:,5,:].T - np.mean(allYhat[:,5,:].T,axis=0),'s-',markersize=3)
axs[1].plot(happiness-np.mean(happiness),'ko-',linewidth=4,label='Obserwacje')
axs[1].set_xlabel('Identyfikator studenta')
axs[1].set_ylabel('Zadowolenie z życia')
axs[1].set_title('Każda prosta ma inny współczynnik przecięcia')
axs[1].legend()

plt.show()

# Wszystkie wyrazy wolne leżą na tej samej prostej. Nie jest to zaskakujące, biorąc pod uwagę że
# wyraz wolny modelu liniowego jest po prostu średnią ze wszystkich przesunięć.
#
# Wniosek jest taki, że  w tym przykładzie współczynnik R^2 nie jest dobrą miarą dopasowania modelu.
# Oczywiście nie oznacza to, że ten wskaźnik do niczego się nie nadaje, a raczej to
# że musisz starannie dobieraj metryki, których używasz do oceny dopasowania modelu do danych.

